/** @file   barrellcontroller.cpp
 * @brief   Implementation of BarrellController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "barrellcontroller.h"

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================

/** Constructor
 */
BarrellController::BarrellController( GameObject* aOwner ) :
  BaseController( aOwner ),
  iState( KWaiting )
{
}



/** Destructor
 */
BarrellController::~BarrellController()
{
}




///
/// Public methods
/// ==============

/** Updates this controller.
 */
void BarrellController::update()
{
  this->reset();
  
  switch ( iState ) {
    case ( KWaiting ): {
      break;
    }
    case ( KProwl ): {
      // If the target is close enough, we explode
      break;
    }
    case ( KRolling ): {
      this->forward() = 1;
      break;
    }
  }
}



/** Sets the state
 */
void BarrellController::setState( int aState )
{
  iState = aState;
}



///
/// Getter methods
/// ==============

/** Returns the current state
 */
int BarrellController::state() const
{
  return iState;
}




///
/// Private or Protected methods
/// ============================

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: barrellcontroller.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:33+02  lamminsa
 * Initial revision
 *
 */
